function [data] = join_sum(filename_tmp,pathname_tmp,filterindex)
%This function takes asks you to open a bunch of summary files from
%savpivots and it will collate them all together as one file.
%Synatax:   [data] = join_sum();
%Input:     filename_tmp = the filenames to be opened
%           pathname_tmp = the pathname of the files
%           filterindex = the type of files.
%Output:    data = the joined data set, with each properties represented as
%               a single slice of the matrix.

if nargin==0    %no input, one data
    prompt_box('title','Open Summary Data','prompt1','Select the summary datasets you want to combine.','position','center');
    getfiles = 1;
else
    getfiles = 0;
end
pause(0.25);
open_data = 0;      %initialize open files switch
data = [];
namestr = [];
while open_data==0
    verti_tmp = [];
    if getfiles
        [filename_tmp,pathname_tmp,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.xlsx','Excel 2007 files (*.xlsx)';...
            '*.xls','Excel files (*.xls)';'*.*','All Files';},...
            'Open Summary Data','Multiselect','on');
    end
    %Now open the data sets according to the filter used.
    switch filterindex
        case {2,3}              %excel file
            for i = 1:size(filename_tmp,2)
                try     %no empty files
                    verti_tmp = single(xlsread([pathname_tmp,filename_tmp{1,i}]));
                end
                if ~isempty(verti_tmp)
                    verti_tmp = reshape(verti_tmp,size(verti_tmp,1),1,size(verti_tmp,2));   %rotate the array into a z array.
                    data = horzcat(data,verti_tmp);       %join all the opened data together
                    filenames{i} = strtrim(filename_tmp{1,i}(1:end-4));  %create a cell array of file names
                    namestr = [namestr,',filenames{',int2str(i),'}'];   %create the string to labe the columns of the dataset
                end
            end
            namestr = [namestr,'});'];  %the end cap
        case {1,5}                  %text file - Default coma delimited
            for i = 1:size(filename_tmp,2)
                try     %just in case of empty files
                    %verti_tmp{i} = single(dlmread([pathname_tmp,filename_tmp{1,i}],','));
                    verti_tmp = single(dlmread([pathname_tmp,filename_tmp{1,i}],',',1,0));
                end
                if ~isempty(verti_tmp)  %if there is data move forward
                    verti_tmp = reshape(verti_tmp,size(verti_tmp,1),1,size(verti_tmp,2));   %rotate the array into a z array.
                    data = horzcat(data,verti_tmp);       %join all the opened data together
                    filenames{i} = strtrim(filename_tmp{1,i}(1:end-4));
                    namestr = [namestr,',filenames{',int2str(i),'}'];   %create the string to labe the columns of the dataset
                end
            end
            namestr = [namestr,'});'];  %the end cap
    end
    if getfiles     %if user input, no need to ask again
        open_data = yes_no_box('title','Are you done selecting data?','caption1','Select yes is you want to move on.',...
            'caption2','Select no if you want to import another dataset.','position','center');
    else
        open_data = 1;  %out loop
    end
end

%now save out the data file
if ~isempty(data)   %proceed if there is data
    for j = 1:size(data,3)     %step through the properties
        funcstr = ['dataset({data(:,:,',int2str(j),')']; %the function string for eval
        data_tmp = eval([funcstr,namestr]);
        sav2csv(data_tmp,['col_sum.prop',num2str(j),'.csv'],pathname_tmp);
    end
end